



<html>
<head>
  <title>javabog.dk - Webprogrammering med Java Server Pages - Grundelementer i JSP</title>
  <link rev="stylesheet" type="text/css" href="../typografi.css">
  <meta name="description" content="Lrebog i Java. Af Jacob Nordfalk. Udkommet hos Forlaget Globe">
  <meta name="keywords" content="designmnster, programmering, OOP, objekter, klasser, objektorienteret programmering, Java, JSP, lrebog, UML, IT">
</head>
<body bgcolor="#ffffff">



<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel1.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel3.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_JSP.html'>om bogen</a>

<H1 CLASS="western" STYLE="">2 <a name='afsn2'></a>Grundelementer
i JSP</H1>
<DIV ID="Indholdsfortegnelse3">
  <P STYLE="margin-top: 0.5cm; margin-bottom: 0cm"><BR>
  </P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>2.1
  JSP-programkode  28</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">2.1.1
  En simpel side med HTML-kode  28</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">2.1.2
  L&aelig;gge JSP-serverkode ind i siden  28</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">2.1.3
  Eksempel: Dags dato og tid  29</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">2.1.4
  Hvis du ikke har en server til r&aring;dighed  29</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">2.1.5
  JSTL - en ny m&aring;de at arbejde p&aring;  29</FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>2.2
  Variabler  30</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">2.2.1
  Indlejrede java-udtryk  31</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">2.2.2
  Variabler med objekter  31</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">2.2.3
  Importere klassedefinitioner (pakker)  32</FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>2.3
  Blanding af HTML og Java - to stilarter  33</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">2.3.1
  Blandet Java og HTML  33</FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>2.4
  Data om klienten (request-objektet)  34</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>2.5
  Kommentarer  35</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>2.6
  Test dig selv  36</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>2.7
  Resum&eacute;  36</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>2.8
  Avanceret  37</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">2.8.1
  L&aelig;se filer fra harddisken  37</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">2.8.2
  Erkl&aelig;ring af metoder og blivende variabler  38</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">2.8.3
  Tr&aring;dsikkerhed i JSP-sider  39</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">2.8.4
  Producere grafik fra JSP  40</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">2.8.5
  Eksempel: JSP-side der danner et JPG-billede  40</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">2.8.6
  Indlejre og nedskalere billeder fra harddisken  43</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">2.8.7
  Opload af filer til server  44</FONT></FONT></P>
</DIV>






<P CLASS="kapiteloversigt-western">En grundig forst&aring;else af
emnerne i dette kapitel foruds&aelig;ttes i resten af bogen. <BR>Bem&aelig;rk:
De avancerede emner i slutningen af kapitlet foruds&aelig;ttes ikke,
de er frivillig l&aelig;sning, du senere kan vende tilbage til.</P>
<P CLASS="western" STYLE="">I dette kapitel
laver vi den allerf&oslash;rste helt simple JSP-fil. Her kan du ogs&aring;
teste, om din server er sat rigtigt op og kan k&oslash;re JSP. 
</P>
<P CLASS="western">Grundl&aelig;ggende er en JSP-fil en tekstfil med
endelsen <STRONG CLASS="western">.jsp</STRONG>, som best&aring;r af:</P>
<UL>
  <LI><P CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">Tekst
    </P>
  <LI><P CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">HTML-koder</P>
  <LI><P CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">JSP-programkode</P>
</UL>
<P CLASS="western">Tekst og HTML-koder kender du, s&aring; lad os
kigge lidt mere p&aring; JSP-programkoden.</P>
<H2 CLASS="western">2.1 <a name='afsn2.1'></a>JSP-programkode</SPAN></H2>
<P CLASS="western">N&aring;r man programmerer JSP s&aring; skriver
man i virkeligheden i programmeringssproget Java. Derfor kan det v&aelig;re
en god ide at l&aelig;re lidt Java undervejs, f.eks. ved at kigge p&aring;
de f&oslash;rste kapitler af af en l&aelig;rebog som
<A CLASS="western" HREF="http://javabog.dk/">http://javabog.dk</A>.</P>
<H3 CLASS="western">2.1.1 <a name='afsn2.1.1'></a>En simpel side med HTML-kode</H3>
<P CLASS="western">Start med at lave et ganske almindeligt
HTML-dokument, navngiv filen <EM CLASS="western">hej.jsp</EM>, og
<SPAN LANG="da-DK">placer</SPAN> den sammen med de andre JSP-filer
der fulgte med din webserver (med Tomcat er stien nok
jakarta-tomcat-5.0.27/webapps/ROOT/hej.jsp). HTML-koden skal se s&aring;dan
her ud:</P>
<PRE CLASS="ikke-javakode-western">&lt;html&gt;
&lt;head&gt;&lt;title&gt;Hej&lt;/title&gt;&lt;/head&gt;
&lt;body&gt;
Her kommer noget JSP-kode:

&lt;/body&gt;
&lt;/html&gt;</PRE><P CLASS="western">
Pr&oslash;v s&aring; at hente siden gennem webserveren. 
</P>
<P CLASS="western">Sandsynligvis er adressen
<A CLASS="western" HREF="http://localhost:8080/hej.jsp">http://localhost:8080/hej.jsp</A>.</P>
<H3 CLASS="western">2.1.2 <a name='afsn2.1.2'></a>L&aelig;gge JSP-serverkode ind i siden</H3>
<P CLASS="western">Husk at JSP er at skrive opgaver til en server, og
lad os s&aring; pr&oslash;ve at skrive en opgave til serveren. For at
fort&aelig;lle serveren, hvad den skal kigge efter, m&aring; vi have
nogle koder som fort&aelig;ller, hvorn&aring;r serverkoderne <I>starter</I>
og <I>slutter</I>. I JSP bruger man <STRONG CLASS="western">&lt;%</STRONG>
og <STRONG CLASS="western">%&gt;</STRONG> til at markere start og
slut p&aring; det, som serveren skal udf&oslash;re.</P>
<P CLASS="western">Pr&oslash;v derefter at tilf&oslash;je f&oslash;lgende
helt simple kodestump til din HTML-kode:</P>
<IMG SRC="bog3_html_m359bb17a.png" NAME="Grafik46" ALIGN=RIGHT BORDER=0>
<PRE CLASS="kode-western">&lt;html&gt;
&lt;head&gt;&lt;title&gt;Hej&lt;/title&gt;&lt;/head&gt;
&lt;body&gt;
Her kommer noget JSP-kode:

<B>&lt;%</B>
  out.println( &quot;&lt;h1&gt;Hej verden!&lt;/h1&gt;&quot; );
<B>  out.println( &quot;To plus to er: &quot; );</B>
<B>  out.println( 2 + 2 );</B>
<B>%&gt;</B>

&lt;/body&gt;
&lt;/html&gt;</PRE><P CLASS="western">
N&aring;r du nu ser JSP-dokumentet i en netl&aelig;ser, skulle
resultatet gerne v&aelig;re som vist til h&oslash;jre.</P>
<P CLASS="western">Men det interessante viser sig f&oslash;rst, n&aring;r
du f&aring;r vist HTML-koden i netl&aelig;seren (ved at v&aelig;lge
&quot;vis kilde&quot; eller &quot;View Source&quot;):</P>
<PRE CLASS="data-western">&lt;html&gt;
&lt;head&gt;&lt;title&gt;Hej&lt;/title&gt;&lt;/head&gt;
&lt;body&gt;
Her kommer noget JSP-kode:

&lt;h1&gt;Hej verden!&lt;/h1&gt;
<B>To plus to er: </B>
<B>4</B>

&lt;/body&gt;
&lt;/html&gt;</PRE><P CLASS="western">
JSP-koderne er v&aelig;k. Som allerede n&aelig;vnt er det kun
serveren som kan se JSP-koderne - klienten (netl&aelig;seren) ser kun
resultatet af beregningerne. Serveren har udf&oslash;rt Java-koden:</P>
<PRE CLASS="kode-western"><B>  out.println( &quot;&lt;h1&gt;Hej verden!&lt;/h1&gt;&quot; );</B>
<B>  out.println( &quot;To plus to er: &quot; );</B>
<B>  out.println( 2 + 2 );</B></PRE><P CLASS="western">
Lidt teknisk <SPAN LANG="da-DK">udtrykt</SPAN> ville man sige, at her
brugte vi out-objektets metode <SPAN LANG="da-DK">println</SPAN>()
til at skrive strenge til klienten. Bem&aelig;rk at <SPAN LANG="da-DK">Java-kommandoer</SPAN>
altid afsluttes med semikolon (;).</P>
<H3 CLASS="western">2.1.3 <a name='afsn2.1.3'></a>Eksempel: Dags dato og tid</H3>
<P CLASS="western">Lad os pr&oslash;ve at f&aring; serveren til at
skrive noget andet. Vi kunne f.eks. bede den om at udskrive den
aktuelle dato og tidspunkt:</P>
<IMG SRC="bog3_html_5a96f386.png" NAME="Grafik1" ALIGN=RIGHT BORDER=0>
<PRE CLASS="kode-western">&lt;html&gt;
&lt;head&gt;&lt;title&gt;Tiden&lt;/title&gt;&lt;/head&gt;
&lt;body&gt;
<B>&lt;%</B>
<B>  out.print( new java.util.Date() );</B>
<B>%&gt;</B>
&lt;/body&gt;
&lt;/html&gt;</PRE><P CLASS="western">
Vi kan alts&aring; f&aring; serveren til at udskrive dato og
tidspunkt, n&aring;r JSP-siden vises. Bem&aelig;rk, at hvis man
trykker p&aring; opdater/genindl&aelig;s/reload i sin netl&aelig;ser,
vises et nyt tidspunkt. Serveren beregner og udskriver alts&aring;
dato og tidspunkt hver gang siden sendes til en klient.</P>
<P CLASS="western">Det er ogs&aring; v&aelig;sentligt at bem&aelig;rke,
at den HTML-kode klienten ser, ikke indeholder andet end datoen. Det
vil sige at JSP ikke stiller krav til, hvilken netl&aelig;ser, der
anvendes. Det er s&aring;ledes s&aring;dan, at ting, der er lavet med
serverside teknologier, virker i <I>alle</I> netl&aelig;sere.</P>
<H3 CLASS="western">2.1.4 <a name='afsn2.1.4'></a>Hvis du ikke har en server til r&aring;dighed</H3>
<P CLASS="western">Hvis du ikke har en server, der kan k&oslash;re
JSP, til r&aring;dighed, kan du pr&oslash;ve alle eksemplerne fra
bogen p&aring; <A CLASS="western" HREF="http://javabog.dk:8080/JSP/kode/">http://javabog.dk:8080/JSP/kode/</A>.
Ovenst&aring;ende eksempel har s&aring;ledes adressen
<A CLASS="western" HREF="http://javabog.dk:8080/JSP/kode/kapitel_02/hej.jsp" TARGET="_new">http://javabog.dk:8080/JSP/kode/kapitel_02/hej.jsp</A>
.</P>
<H3 CLASS="western">2.1.5 <a name='afsn2.1.5'></a>JSTL - en ny m&aring;de at arbejde p&aring;</H3>
<P CLASS="western">Er du ikke s&aring; erfaren med Java er JSTL (JSP
Standard Tag Library), der beskrives i <a href='kapitel6.jsp'>kapitel 6</a>, JSTL - JSP Standard Tag Library,
nok lettere for dig end Java. JSTL er et HTML-lignende sprog som man
kan skrive koden, der udf&oslash;res p&aring; serveren i, i stedet
for Java.</P>
<P CLASS="western">I <a href='kapitel6.jsp'>kapitel 6</a> er der en r&aelig;kke eksempler med
JSTL, der g&oslash;r det samme som eksemplerne i dette og de
efterf&oslash;lgende kapitler. Selvom denne bogs 'hovedsprog' er Java
og ikke JSTL kan du derfor v&aelig;lge at l&aelig;re JSTL i stedet
ved at l&aelig;se hovedteksten og s&aring; ved Java-eksemplerne i
stedet  kigge p&aring; og lege med JSTL-eksemplerne i <a href='kapitel6.jsp'>kapitel 6</a>.</P>
<H2 CLASS="western" STYLE="">2.2 <a name='afsn2.2'></a>Variabler</SPAN></H2>
<P CLASS="western">En variabel kan opfattes som en navngiven
<SPAN LANG="da-DK">papirlap</SPAN>, hvor der til enhver tid kan st&aring;
netop &eacute;n ting. Variabler bruges til at huske data.</P>
<P CLASS="western">Variabler i Java skal altid erkl&aelig;res, dvs.
at man skal fort&aelig;lle serveren, at der skal oprettes en
variabel, hvad slags data den skal indeholde og hvad den skal hedde:</P>
<PRE CLASS="kode-western">  int alder = 31;</PRE><P CLASS="western">
Her har vi oprettet variablen alder. Den er af typen int, det vil
sige at den kan indeholde hele tal. Samtidig har vi givet (eller
tildelt) den v&aelig;rdien 31. 
</P>
<P CLASS="western">Senere kunne vi s&aring; hente v&aelig;rdien frem
ved at skrive variablens navn. Her er et eksempel:</P>
<P ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm"><FONT SIZE=2 STYLE="font-size: 9pt"><I>alder.jsp
(JSTL-eksempel i <a href='kapitel6.jsp#afsn6.1'>afsnit 6.1</a>)</I></FONT></P>
<PRE CLASS="kode-western">&lt;html&gt;
&lt;head&gt;&lt;title&gt;Alder&lt;/title&gt;&lt;/head&gt;
&lt;body&gt;
&lt;p&gt;
&lt;%
<B>  int alder = 31;</B>

  out.print( &quot;S&oslash;ren er &quot; + <B>alder</B> + &quot; &aring;r gammel. &quot; );
  out.print( &quot;Det svarer til &quot; + <B>12*alder</B> + &quot; m&aring;neder. &lt;br&gt;&quot; );

  <B>alder = 3;</B>
  out.print( &quot;Julie er &quot; + <B>alder</B> + &quot; &aring;r gammel. &quot; );

<B>  alder = alder*365;</B>
  out.print( &quot;Det svarer cirka til &quot; + <B>alder</B> + &quot; dage. &lt;br&gt;&quot; );
%&gt;
&lt;/p&gt;
&lt;/body&gt;
&lt;/html&gt;</PRE><P CLASS="western">
Resultatet i en netl&aelig;ser er:</P>
<P CLASS="western" ALIGN=CENTER><IMG SRC="bog3_html_m65284c86.png" NAME="Grafik2" BORDER=0></P>
<P CLASS="western">Bem&aelig;rk, at n&aring;r en variabel tildeles en
ny v&aelig;rdi, bliver den gamle v&aelig;rdi fuldst&aelig;ndig glemt.
</P>
<P CLASS="western">Bem&aelig;rk ogs&aring;, at p&aring; h&oslash;jre
side af lighedstegnet i en tildeling kan st&aring; et <SPAN LANG="da-DK">regneudtryk</SPAN>,
der i s&aring; fald beregnes f&oslash;r variablen tildeles v&aelig;rdien.
</P>
<P CLASS="western"><SPAN LANG="da-DK">Udtrykket</SPAN> alder =
alder*365 g&oslash;r alts&aring; det, at det beregner alder*365, der
giver 3*365=1095. Denne v&aelig;rdi <SPAN LANG="da-DK">puttes</SPAN>
derefter ind i variablen alder.</P>
<H3 CLASS="western" STYLE="">2.2.1 <a name='afsn2.2.1'></a>Indlejrede
java-udtryk</H3>
<P CLASS="western">I koden &lt;%=  %&gt; kan skrives et Java-udtryk,
der bliver beregnet p&aring; serveren og indsat i HTML-koden hver
gang siden hentes.</P>
<P CLASS="western">&lt;%= dato %&gt; er alts&aring; bare en kortere
m&aring;de at skrive &lt;% out.print(dato); %&gt; p&aring;.</P>
<P CLASS="western">Her er en side, der udskriver 7-tabellen ved hj&aelig;lp
af &lt;%=  %&gt;:</P>
<P ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm"><FONT SIZE=2 STYLE="font-size: 9pt"><I><SPAN LANG="da-DK">syvtabellen.jsp</SPAN>
(JSTL-eksempel i <a href='kapitel6.jsp#afsn6.1.5'>afsnit 6.1.5</a>)</I></FONT></P>
<PRE CLASS="kode-western">&lt;html&gt;<IMG SRC="bog3_html_60648dfb.png" NAME="Grafik4" ALIGN=RIGHT BORDER=0>
&lt;head&gt;&lt;title&gt;<SPAN LANG="da-DK">Syvtabellen</SPAN>&lt;/title&gt;&lt;/head&gt;
&lt;body&gt;
&lt;p&gt;Her er syv-tabellen:&lt;br&gt;

&lt;% 
  for (int i=1; i&lt;=10; i++)
  {
%&gt;
    Syv gange <B>&lt;%= i %&gt;</B> er: <B>&lt;%= 7*i %&gt;</B>.&lt;br&gt;
&lt;% 
  } 
%&gt;
&lt;/p&gt;
&lt;/body&gt;
&lt;/html&gt;</PRE><P CLASS="western">
Bem&aelig;rk at en klump javakode gerne m&aring; slutte, selvom der
mangler en }-parentes til at afslutte den blok kode, der skulle
udf&oslash;res i for-l&oslash;kken, blot der senere kommer endnu en
klump javakode, hvori blokken afsluttes (det kommer vi tilbage til i
<a href='kapitel2.jsp#afsn2.3.1'>afsnit 2.3.1</a>).</P>
<H3 CLASS="western">2.2.2 <a name='afsn2.2.2'></a>Variabler med objekter</H3>
<P CLASS="western">I eksemplet i <a href='kapitel2.jsp#afsn2.1.3'>afsnit 2.1.3</a> skrev vi <B>new
java.util.Date()</B>, hvilket opretter et objekt, som repr&aelig;senterer
den aktuelle dato og tid p&aring; serveren. 
</P>
<P CLASS="western">S&aring;dan et objekt kan man ogs&aring; gemme i
en variabel, s&aring;dan her:</P>
<PRE CLASS="kode-western">  java.util.Date tiden = new java.util.Date();</PRE><P CLASS="western">
og s&aring; bagefter udskrive objektet p&aring; sk&aelig;rmen:</P>
<PRE CLASS="kode-western">  out.print( tiden );</PRE><P CLASS="western">
Lad os udvide eksemplet og b&aring;de udskrive en streng og et
objekt, som vi samler med +:</P>
<IMG SRC="bog3_html_4fbe1417.png" NAME="Grafik5" ALIGN=RIGHT BORDER=0>
<PRE CLASS="kode-western">&lt;html&gt;
&lt;head&gt;&lt;title&gt;Tiden 2&lt;/title&gt;&lt;/head&gt;
&lt;body&gt;
<B>&lt;%</B>
<B>  java.util.Date tiden = new java.util.Date();</B>
<B>  out.print( &quot;Dato og tid er: &quot; + tiden );</B>
<B>%&gt;</B>
&lt;/body&gt;
&lt;/html&gt;</PRE><P CLASS="western">
N&aring;r netl&aelig;seren anmoder om siden, udf&oslash;rer serveren
JSP-koden og sender til klienten:</P>
<PRE CLASS="data-western">&lt;html&gt;
&lt;head&gt;&lt;title&gt;Tiden 2&lt;/title&gt;&lt;/head&gt;
&lt;body&gt;
Dato og tid er: Wed <SPAN LANG="da-DK">Aug</SPAN> 28 16:00:42 CEST 2002
&lt;/body&gt;
&lt;/html&gt;</PRE>
<H3 CLASS="western">2.2.3 <a name='afsn2.2.3'></a>Importere klassedefinitioner (pakker)</H3>
<P CLASS="western">I stedet for hele tiden at skrive Date-klassens
fulde navn (som er java.util.Date) kan vi ogs&aring; importere
java.util.* (alle klasser i pakken java.util) og s&aring;ledes undg&aring;
at skrive pakkenavnet. 
</P>
<P CLASS="western">Til det skal vi bruge side-direktivet &lt;%@ page
...  %&gt;, der kan bruges til at angive en r&aelig;kke ting om
hvordan serveren skal udf&oslash;re siden (side-direktivet bliver
grundigere beskrevet senere, i <a href='kapitel4.jsp#afsn4.4'>afsnit 4.4</a>):</P>
<PRE CLASS="kode-western"><B>&lt;%@ page language=&quot;java&quot; import=&quot;java.util.*&quot; %&gt;</B>
&lt;html&gt;
&lt;head&gt;&lt;title&gt;Tiden 3 - import af pakke&lt;/title&gt;&lt;/head&gt;
&lt;body&gt;
<B>&lt;%</B>
<B>  Date tiden = new Date();</B>
<B>  out.print( &quot;&lt;p&gt;Dato og tid er: &quot; + tiden + &quot;&lt;/p&gt;&quot; );</B>
<B>%&gt;</B>
&lt;/body&gt;
&lt;/html&gt;</PRE><H4 CLASS="western">
Importere flere pakker</H4>
<P CLASS="western">Vil man importere klasser fra flere pakker skriver
man dem adskilt af komma, f.eks. <SPAN STYLE="font-weight: medium">import=&quot;java.util.*,java.text.*&quot;.</SPAN></P>
<P CLASS="western">Med det kan vi lave en lidt <SPAN LANG="da-DK">p&aelig;nere</SPAN>
side, der udskriver datoen og tiden:</P>
<PRE CLASS="kode-western" STYLE="font-weight: medium">&lt;%@ page language=&quot;java&quot; import=&quot;java.util.*,java.text.*&quot; %&gt;
&lt;html&gt;
&lt;head&gt;&lt;title&gt;Tiden 4 - import af flere pakker&lt;/title&gt;&lt;/head&gt;
&lt;body&gt;
<B>&lt;%</B>
<B>    DateFormat klformat, datoformat;</B>

<B>    klformat   = DateFormat.getTimeInstance(DateFormat.SHORT);</B>
<B>    datoformat = DateFormat.getDateInstance(DateFormat.FULL);</B>

<B>    Date tid = new Date();</B>
<B>    String kl = klformat.format(tid);</B>
<B>    String dato = datoformat.format(tid);</B>
<B>%&gt;</B>
&lt;p&gt;Datoen i dag er <B>&lt;%= dato %&gt;</B>, og klokken er <B>&lt;%= kl %&gt;</B>.&lt;/p&gt;
&lt;/body&gt;
&lt;/html&gt;</PRE><P CLASS="western">
Resultatet i en netl&aelig;ser er:</P>
<P CLASS="western" ALIGN=CENTER><IMG SRC="bog3_html_m1ca0208.png" NAME="Grafik8" ALIGN=BOTTOM BORDER=0></P>

<H2 CLASS="western" STYLE="">2.3 <a name='afsn2.3'></a>Blanding af
HTML og Java - to stilarter</SPAN></H2>
<P CLASS="western">Lad os skrive tidspunktet p&aring; dagen. Det kan
vi g&oslash;re med en r&aelig;kke k&aelig;dede if-s&aelig;tninger:</P>
<P ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm"><FONT SIZE=2 STYLE="font-size: 9pt"><I>java_og_html_adskilt.jsp
(JSTL-eksempel i <a href='kapitel6.jsp#afsn6.2.2'>afsnit 6.2.2</a>)</I></FONT></P>
<PRE CLASS="kode-western" STYLE="font-weight: medium">&lt;%@ page language=&quot;java&quot; import=&quot;java.util.*&quot; %&gt;<IMG SRC="bog3_html_me1e42b8.png" NAME="Grafik6" ALIGN=RIGHT BORDER=0>
&lt;html&gt;
&lt;head&gt;
&lt;title&gt;Java og HTML adskilt&lt;/title&gt;&lt;/head&gt;
&lt;body&gt;
Det er lige nu:
<B>  &lt;%</B>
<B>    Date tid = new Date();</B>
<B>    int t = <SPAN LANG="da-DK">tid.getHours</SPAN>();</B>
<B>    if (t &lt;= 9)       out.print(&quot;morgen&quot;);</B>
<B>    else if (t &lt;= 12) out.print(&quot;formiddag&quot;);</B>
<B>    else if (t &lt;= 17) out.print(&quot;eftermiddag&quot;);</B>
<B>    else if (t &lt;= 21) out.print(&quot;aften&quot;);</B>
<B>    else              out.print(&quot;nat&quot;);</B>
<B>  %&gt;</B>
&lt;/body&gt;
&lt;/html&gt;</PRE><P CLASS="western">
De fleste foretr&aelig;kker at bruge out-objektet til udskrivning,
som vist ovenfor, for p&aring; denne m&aring;de at adskille Java og
HTML.</P>
<H3 CLASS="western">2.3.1 <a name='afsn2.3.1'></a>Blandet Java og HTML</H3>
<P CLASS="western">Men det er faktisk muligt at starte og stoppe
<SPAN LANG="da-DK">javakoden</SPAN> med &lt;% og %&gt; i stedet:</P>
<PRE CLASS="kode-western" STYLE="font-weight: medium">&lt;%@ page language=&quot;java&quot; import=&quot;java.util.*&quot; %&gt;
&lt;html&gt;
&lt;head&gt;&lt;title&gt;Java og HTML blandet&lt;/title&gt;&lt;/head&gt;
&lt;body&gt;
Det er lige nu:
<B>  &lt;%</B>
<B>    Date tid = new Date();</B>
<B>    int t = tid.getHours();</B>
<B>    if (t &lt;= 9)       { %&gt; morgen      &lt;% }</B>
<B>    else if (t &lt;= 12) { %&gt; formiddag   &lt;% }</B>
<B>    else if (t &lt;= 17) { %&gt; eftermiddag &lt;% }</B>
<B>    else if (t &lt;= 21) { %&gt; aften       &lt;% }</B>
<B>    else              { %&gt; nat         &lt;% }</B>
<B>  %&gt;</B>
&lt;/body&gt;
&lt;/html&gt;</PRE><P CLASS="western">
For de fleste er det forvirrende med denne sammenblanding af HTML og
Java. Derfor foretr&aelig;kker de fleste at bruge out-objektet (en
tredje mulighed er at bruge JSTL, se hvordan i <a href='kapitel6.jsp#afsn6.2'>afsnit 6.2</a>).</P>
<P CLASS="western">Dette eksempel kan dog virke besn&aelig;rende for
nogen, fordi det ser mere overskueligt ud. Man skal dog v&aelig;re
meget omhyggelig med at omkranse HTML-koden i {- og }-parenteser.</P>
<BLOCKQUOTE CLASS="definition-western">Husk altid at bruge { og } i
betingelser og l&oslash;kker hvis de har indlejret HTML</BLOCKQUOTE>
<BLOCKQUOTE CLASS="definition-western">Man skal v&aelig;re omhyggelig
med, at der altid er lige mange {-startparenteser som
}-slutparenteser 
</BLOCKQUOTE>

<P CLASS="western" STYLE="">Er der ikke lige
mange {- og }-blokparenteser f&aring;r man kryptiske<A CLASS="sdfootnoteanc" NAME="sdfootnote1anc" HREF="#sdfootnote1sym"><SUP>1</SUP></A>
fejlmeddelelser s&aring;som:</P>
<PRE CLASS="western">  'try' without 'catch' or 'finally'
  'catch' without 'try'
  'else' without 'if'</PRE><H2 CLASS="western">
2.4 <a name='afsn2.4'></a>Data om klienten (request-objektet)</SPAN></H2>
<P CLASS="western">Out-objektet er et eksempel p&aring; et objekt,
der automatisk findes i alle JSP-sider. 
</P>
<P CLASS="western">Der findes flere af den slags objekter (i <a href='kapitel4.jsp#afsn4.5'>afsnit
4.5</a>, Appendiks: Implicit definerede objekter, er de beskrevet i
detaljer), bl.a. et <I>request</I>-objekt (beskrevet i <a href='kapitel4.jsp#afsn4.5.1'>afsnit 4.5.1</a>).
Dette objekt repr&aelig;senterer alt det serveren ved om klienten og
med det kan vi f&aring; en r&aelig;kke ting at vide om klienten og
den foresp&oslash;rgsel der blev foretaget.</P>
<PRE CLASS="kode-western">&lt;html&gt;
&lt;head&gt;&lt;title&gt;Data om klienten&lt;/title&gt;&lt;/head&gt;
&lt;body&gt;
&lt;h1&gt;Nogle data om klienten (request-objektet)&lt;/h1&gt;
&lt;pre&gt;
<SPAN STYLE="font-weight: medium">Fuld URL  - <SPAN LANG="da-DK">getRequestURL</SPAN>(): &lt;%= request.getRequestURL() %&gt;</SPAN>

Metode    - getMethod():      &lt;%= request.getMethod() %&gt;
Protokol  - getProtocol():    &lt;%= request.getProtocol() %&gt;
V&aelig;rtsnavn - <SPAN LANG="da-DK">getServerName</SPAN>():  &lt;%= <SPAN LANG="da-DK">request.getServerName</SPAN>() %&gt;
Port      - <SPAN LANG="da-DK">getServerPort</SPAN>():  &lt;%= <SPAN LANG="da-DK">request.getServerPort</SPAN>() %&gt;
Webapp    - getContextPath(): &lt;%= request.getContextPath() %&gt;
Sti i app - getServletPath(): &lt;%= request.getServletPath() %&gt;

Filplacering p&aring; harddisk: &lt;%= application.getRealPath(request.getServletPath()) %&gt;

Klients IP-adresse - getRemoteAddr(): &lt;%= request.getRemoteAddr() %&gt;
Foretrukne sprog   - getLocale():     &lt;%= request.getLocale() %&gt;
Netl&aelig;ser/browser   header user-agent: &lt;%= request.getHeader(&quot;user-agent&quot;) %&gt;
&lt;/pre&gt;
&lt;/body&gt;
&lt;/html&gt;</PRE><P CLASS="western">
Pr&oslash;v eksemplet p&aring;
<A CLASS="western" HREF="http://javabog.dk:8080/JSP/kode/kapitel_02/data_om_klienten.jsp">http://javabog.dk:8080/JSP/kode/kapitel_02/data_om_<SPAN LANG="da-DK">klienten.jsp</SPAN></A><SPAN LANG="da-DK">.</SPAN></P>
<P CLASS="western" ALIGN=CENTER><IMG SRC="bog3_html_73470b60.png" NAME="Grafik7" ALIGN=BOTTOM BORDER=0></P>
<H2 CLASS="western">2.5 <a name='afsn2.5'></a>Kommentarer</SPAN></H2>
<P CLASS="western">Med &lt;%-- og --%&gt; kan man inds&aelig;tte
kodekommentarer i JSP. Disse fungerer lidt anderledes end
HTML-kommentarer, som man laver med &lt;!-- og --&gt;. 
</P>
<PRE CLASS="kode-western">&lt;html&gt;
&lt;head&gt;&lt;title&gt;Hej med HTML- og JSP-kommentarer&lt;/title&gt;&lt;/head&gt;
&lt;body&gt;
Her kommer noget JSP-kode:

  &lt;% out.println( &quot;&lt;h1&gt;Hej verden!&lt;/h1&gt;&quot; ); %&gt;

<I>&lt;!-- HTML-kommentar</I>
<I>  &lt;% out.println( &quot;To plus to er: &quot; ); %&gt; </I>
<I>--&gt;</I>

<I>&lt;%-- JSP-kommentar</I>
<I>  &lt;% out.println( 2 + 2 ); %&gt;</I>
<I>--%&gt;</I>

&lt;/body&gt;
&lt;/html&gt;</PRE><P CLASS="western">
I bogen her bliver kommentarer skrevet i <I>kursiv</I> for
l&aelig;selighedens skyld.</P>
<P CLASS="western">Grunden til at JSP har sin egen m&aring;de at lave
kommentarer p&aring;, er at JSP-kommentarer med &lt;%-- og --%&gt;
(til forskel fra HTML-kommentarer med &lt;!-- og --&gt;) slet ikke
bliver udf&oslash;rt p&aring; serveren. De bliver ogs&aring; helt
udeladt af koden, der sendes til klientens netl&aelig;ser. Hvis
ovenst&aring;ende side hentes, vil netl&aelig;seren derfor kun f&aring;
tilsendt (det kan ses med 'vis kilde'):</P>
<PRE CLASS="data-western">&lt;html&gt;
&lt;head&gt;&lt;title&gt;Hej med HTML- og JSP-kommentarer&lt;/title&gt;&lt;/head&gt;
&lt;body&gt;
Her kommer noget JSP-kode:

<B>  </B>&lt;h1&gt;Hej verden!&lt;/h1&gt;

&lt;!-- HTML-kommentar
  To plus to er: 
--&gt;


&lt;/body&gt;
&lt;/html&gt;</PRE><P CLASS="western">
De almindelige HTML-kommentarer lavet med &lt;!-- og --&gt; vil
netl&aelig;seren udelade i fremvisningen, s&aring; resultatet er, at
netl&aelig;seren ikke viser hverken den ene eller den anden slags
kommentarer:</P>
<P CLASS="western" ALIGN=CENTER><IMG SRC="bog3_html_m77d8efe4.png" NAME="Grafik9" ALIGN=BOTTOM BORDER=0></P>
<H2 CLASS="western">2.6 <a name='afsn2.6'></a>Test dig selv</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel2.jsp#afsn2.6">
  <input type='checkbox' name='vis' value='2.6'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='2.6'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H2 CLASS="western">2.7 <a name='afsn2.7'></a>Resum&eacute;</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel2.jsp#afsn2.7">
  <input type='checkbox' name='vis' value='2.7'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='2.7'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H2 CLASS="western" STYLE="">2.8 <a name='afsn2.8'></a>Avanceret</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel2.jsp#afsn2.8">
  <input type='checkbox' name='vis' value='2.8'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='2.8'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">2.8.1 <a name='afsn2.8.1'></a>L&aelig;se filer fra harddisken</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel2.jsp#afsn2.8.1">
  <input type='checkbox' name='vis' value='2.8.1'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='2.8.1'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">2.8.2 <a name='afsn2.8.2'></a>Erkl&aelig;ring af metoder og blivende
variabler</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel2.jsp#afsn2.8.2">
  <input type='checkbox' name='vis' value='2.8.2'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='2.8.2'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">2.8.3 <a name='afsn2.8.3'></a>Tr&aring;dsikkerhed i JSP-sider</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel2.jsp#afsn2.8.3">
  <input type='checkbox' name='vis' value='2.8.3'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='2.8.3'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">2.8.4 <a name='afsn2.8.4'></a>Producere grafik fra JSP</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel2.jsp#afsn2.8.4">
  <input type='checkbox' name='vis' value='2.8.4'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='2.8.4'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">2.8.5 <a name='afsn2.8.5'></a>Eksempel: JSP-side der danner et
JPG-billede</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel2.jsp#afsn2.8.5">
  <input type='checkbox' name='vis' value='2.8.5'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='2.8.5'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">2.8.6 <a name='afsn2.8.6'></a>Indlejre og nedskalere billeder fra
harddisken</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel2.jsp#afsn2.8.6">
  <input type='checkbox' name='vis' value='2.8.6'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='2.8.6'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">2.8.7 <a name='afsn2.8.7'></a>Opload af filer til server</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel2.jsp#afsn2.8.7">
  <input type='checkbox' name='vis' value='2.8.7'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='2.8.7'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  
<DIV ID="sdfootnote1">
  <P CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote1sym" HREF="#sdfootnote1anc">1</A>Som
  vi senere skal se, i <a href='kapitel7.jsp#afsn7.3'>afsnit 7.3</a>, Avanceret: JSP-siders interne virkem&aring;de,
  bliver JSP-sider lavet om til en metode i en klasse. Derfor er det
  meget vigtigt at {- og }-parenteser er balancerede.</P>
</DIV>
<DIV ID="sdfootnote2">
  <P CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote2sym" HREF="#sdfootnote2anc">2</A>Egentlig
  er servletter (se <a href='kapitel7.jsp#afsn7.1'>afsnit 7.1</a>) mere velegnede til at producere bin&aelig;re
  data end JSP-sider. I eksemplet kommer s&aring;ledes fejlen
  'IllegalStateException: getOutputStream() has already been called
  for this response' i serverens log, selvom eksemplet virker fint.</P>
</DIV>

<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel1.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel3.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_JSP.html'>om bogen</a>
<hr>
<font size=-2>http://javabog.dk/ - <b>Webprogrammering med Java Server Pages</b> af Jacob Nordfalk.
<br>
  Licens og kopiering under <a href='http://www.linuxbog.dk/licens.html'>&Aring;ben Dokumentlicens</a> (&Aring;DL)
  hvor intet andet er nvnt (72% af vrket).
</font>
<br>
nsker du at se de sidste 28% af dette vrk (275315 tegn)
skal du kbe bogen. S fr du pne figurer og layout, stikordsregister og en trykt bog med i kbet.
<!-- netlser: Wget/1.10, autoHent: true  -->
     

</body>
</html>
